## RS485 Module Family
This module (shield) is designed for installation on electrical switchboard. It features 4 electromagnetic relays to control
almost any household electric device: lights, roller shutters, electrical sockets. It also uses 4 analog current sensors to
provide independent measurement for every output. It is case compatible with Raspberry Pi (at least bottom part of the case fits).

**To use this module you need a [RS485 MCU Module](https://www.openhardware.io/view/639/RS485-MCU-Module).**

## Technical Specification:
- 4x SPDT electromagnetic relay (G5Q-1-EU 12VDC),
- 4x ACS712-20A analog current sensor,
- 5V power regulator to power up the logic,
- 12-pin interface for RS485 MCU Module,
- 12x screw terminal for relays,
- 4x screw terminal for RS485 connection (12V, GND, A, B),
- Size of Raspberry Pi (87x58,5 mm),

## Performance
- AC contact rating: 10A/250VAC
- DC contact rating: 5A/30VDC

**Be careful with this module! It operates with 230 VAC and can be dangerous when handled inappropriately!**

## Q&A
We will place typical questions and answers here, if they occur.

## Firmware
See [RS485 MCU Module](https://www.openhardware.io/view/639/RS485-MCU-Module) page for firmware

## Notes
Case .stl files are available in design files section.

## Other information
Copyright feanor-anglin (2018). Released under the [CERN Open Hardware Licence v1.2](http://ohwr.org/cernohl)

We develop Arduino compatibile hardware for wired home automation systems. If you like what we do and want us to keep going, please donate!