## RS485 Modules Family
The first and probably the most important shield for our RS485 MCU Module is here: RS485 2SSR Shield. It was designed for local installation under a light switch. It gives the MCU Module an ability to control AC current with 2 solid state relays. We decided to go with SSRs since the performance they give is sufficient for most applications (roller shutters, modern LED lighting), while they allow to achieve very small size of the module. Moreover it comes with an onboard analog temperature sensor and current sensor. All this in a very small size of 40x33,5 mm (including RS485 MCU Module).

**To use this module you need a [RS485 MCU Module](https://www.openhardware.io/view/639/RS485-MCU-Module).**

## Technical Specification:
- 2x snubberless triacs (T435-800B), each controlled by an optotriac (MOC3043) for optoinsulation,
- ACS712-5A analog current sensor,
- MCP9700AT analog temperature sensor,
- 4A SMD fuse for AC line,
- AMS1117 5V to power up the logic,
- 8-pin interface for RS485 MCU Module,
- 4x screw terminal for RS485 connection (12V, GND, A, B),
- 3x screw terminal for AC connection (L IN, L Out1, L Out2).
- Very small size of 40x28 mm.

## Performance: 
- peak, temporary current output: 4A per channel (note 4A fuse),
- max load for continuous operation: 200W per module (2 channels with 100W load or 1 channel with 200W load). To determine this values under load tests were carried out.

**Be careful with this module! It operates with 230 VAC and can be dangerous when handled inappropriately!**

## Q&A
We will place typical questions and answers here, if they occur.

## Firmware
See [RS485 MCU Module](https://www.openhardware.io/view/639/RS485-MCU-Module) page for firmware.

## Notes
Case .stl file is available in design files section.

## Revisions
Rev. 2 coming soon!

## Other information
Copyright feanor-anglin (2018). Released under the [CERN Open Hardware Licence v1.2](http://ohwr.org/cernohl)

We develop Arduino compatibile hardware for wired home automation systems. If you like what we do and want us to keep going, please donate!
