## RS485 Module Family
We are happy to introduce our RS485 MCU Module, a basis of our RS485 system. It is a small board, compatible with Arduino 
and ready for RS485 wired communication. It was created as a result of our experience with DIY home automation systems and therefore
it benefits from lots of our observations and is designed to be convenient to use and install.
The most important feature is although its versality - we designed it with having an idea in mind to make it compatible with various 
shields and wired extensions, which are meant to extend its functionality.
A compatible 2 channel AC shield is already finished, but we plan to prepare many other shields such as 
dimmers, DIN mountable relays, heating modules, sensor extenions and others.

## Technical Specification:
- ATmega328p microcontroller,
- SP485EE for RS485 wired bus communication (working on hardware serial, pin 0 & 1),
- 64 kb external flash for FOTW updates,
- 12-pin interface for shields (2.0 mm pitch),
- 6 different connector interfaces (1.25 pitch) such as AVRSPI, 1Wire, I2C, Analog I/O pins, Digital I/O pins for buttons/binary sensors,
- 5 PWM available,
- I2C on both pin interface and connector interface,
- Requires 5VDC power input,
- Very small size of 39x25 mm,

## Available pins:
- Pin interface: Power (5V), GND, RS485 (A, B), I2C (A4, A5), A0, A7, D5, D6, D9, D10,
- AVRSPI,
- 1Wire - 5V, GND, A6,
- I2C - 5V, GND, A4, A5,
- Analog - 5V, GND, A1, A2
- Multipurpose I/O 1 - A3, D4, GND,
- Multipurpose I/O 2 - D2, D3, GND.

## List of compatibile shields
Every shield that will ever appear will be listed here.

## Q&A
We will place typical questions and answers here, if they occur.

## Firmware
Although we are not really code developers, we provide some example code which covers most of applications. It can be find here:
- [Main file](https://github.com/feanor-anglin/RS485/tree/master/RS485_FOTW)
- [Additional files](https://github.com/feanor-anglin/DOMATIClib)

## Other information
Copyright feanor-angin (2018). Released under the [CERN Open Hardware Licence v1.2](http://ohwr.org/cernohl)

We develop Arduino compatibile hardware for wired home automation system. If you like what we do and want us to keep going, please donate!
