**The device size is 44 mm x 37mm x 20mm.**


- On Board the device are:
- AM312 (PIR Sensor)
- BH1750FVI (Ambient Light Sensor)
- Atmega328
- 8MHz crystal oscillator (for DIY)
- three-color led
- nrf24l01
- AT25F512B-SSH-T (flash)
- ATSHA204A_SOT23 (cripto)
- TPS627ХХ family (consumption of 360 nA)
- two 14250 batteries (7.2v 1000mA) | [Aliexpress - 14250](https://ru.aliexpress.com/premium/14250.html?d=y&blanktest=0&origin=y&SearchText=14250&tc=ppc&isViewCP=y&catId=0) | [eBay - 14250](https://www.ebay.com/sch/i.html?_from=R40&_trksid=p2512315.m570.l1311.R3.TR5.TRC0.A0.H0.X14250.TRS0&_nkw=14250+battery&_sacat=0)
- FTDI (micro)
- ICSP (micro)
- Two side buttons (first button-reset, the second button - interrupt (DIY)
- Power switch

FTDI/ICSP adapter - gift.

Very long life on one set of batteries -> 3 years

**What can this motion sensor do:**
- Firmware by air.
- Work on all bootloaders.
- Sending the status of the motion sensor to the controller
- Three modes of motion sensor (Night | Day | 24 hours)
- Adjustable delay (without delay | 1minute - 4 hours)
- Sending the remaining battery charge as a percentage
- Sending the illumination level in Luxs

**Configuring via the Mayensors module in Majordomo (...and through any other controller):**
- The interval for sending the remaining battery charge
- Lighting level sending interval
- Setting the operating mode of the signal led (RGB) - Hidden mode | Red | Green | Blue
- Adjusting the level of the illumination limit at which the motion sensor will work
- Set the time delay for the trigger of the motion sensor in the active state. In the same way, the restart of the specified interval is applied programmatically in case of repeated movement during the already detected motion detection.

On board there is a cryptographic board atsha204a-stucz-t
There is also an external SPI Flash AT25F512B-SSH-T
A very interesting down-converter 3.3-10v in 3.3 is used in a very low own consumption of 360 nano-amperes
| Dual-cell Ultra Low IQ Step Down Converter for Low Power Wireless Applications |

Output as FTDI and ICSP, so that complete freedom in manipulating the device. You can use my software. You can write a cool their software. I'm all for it!!!

If all this is described in a nutshell = the device is working cool :)

As a smart home controller, I now use the Majordomo system, it's a full-fledged home Web server on Apache. Screen of the traffic sensor in the Mayensors module in the Majordomo system

![enter image description here](https://www.openhardware.io//uploads/5b55b022d376570b051a9071/image/IMG_26082018_205438_0.png "enter image title here")

"BARRARY SEND"  is my spelling typo in the table... Oh, those Russians.. :)


Program code for this device is added below, this is beta, and works well :) ...I understand a little bit about that...:)

```
#include <Wire.h>
#include <BH1750.h>
BH1750 lightMeter;

#define MY_DEBUG
//#define MY_DISABLED_SERIAL
#define MY_RADIO_RF24
#define MY_OTA_FIRMWARE_FEATURE
//#define MY_SIGNING_ATSHA204
//#define MY_SIGNING_ATSHA204_PIN A3
//#define MY_SIGNING_REQUEST_SIGNATURES

#define MOTION_SENS_ID 1
#define LUX_SENS_ID 2
#define SETTING_LED_SENS_ID 100
#define DELAY_TIME_SENS_ID 101
#define MOTION_MODE_ID 102
#define SETTING_LUX_SENS_ID 103
#define BATTARY_SEND_SENS_ID 104

#define MYLED_ON 1
#define MYLED_OFF 0
#define BAT_COOF 7.4
#define BAT_MIN 350
#define BAT_MAX 720
#define SLEEP_TIME 300000

static uint8_t motion_pin = 3;
static uint8_t bled_pin = 14;
static uint8_t rled_pin = 15;
static uint8_t gled_pin = 16;
uint8_t selected_led;
uint8_t selected_motion_mode;
uint16_t count_batteryTime = 0;
uint16_t lux;
uint16_t boundary_DNlux;
uint32_t send_batteryTime;
uint32_t delayTime;
int8_t battery;
int8_t old_battery;
int8_t woke_up_from;
boolean flag = 0;
boolean flag2 = 0;
boolean flag3 = 0;
boolean sleep_mode = 1;
boolean tripped;
boolean first_send_battery = 1;
boolean flag_motion_mode;

#include <MySensors.h>

MyMessage msg_motion(MOTION_SENS_ID, V_TRIPPED);
MyMessage msg_lux(LUX_SENS_ID, V_LEVEL);
MyMessage msg_setting_led(SETTING_LED_SENS_ID, V_VAR1);
MyMessage msg_delay_time(DELAY_TIME_SENS_ID, V_VAR1);
MyMessage msg_motion_mode(MOTION_MODE_ID, V_VAR1);
MyMessage msg_setting_lux(SETTING_LUX_SENS_ID, V_LEVEL);
MyMessage msg_battary_send(BATTARY_SEND_SENS_ID, V_VAR1);


void preHwInit()
{
  pinMode(motion_pin, INPUT);
  pinMode(gled_pin, OUTPUT);
  pinMode(rled_pin, OUTPUT);
  pinMode(bled_pin, OUTPUT);
  digitalWrite(bled_pin, HIGH);
  digitalWrite(rled_pin, HIGH);
  digitalWrite(gled_pin, HIGH);
}

void before()
{
  selected_led = loadState(100);
  if (selected_led == 255) {
    selected_led = 0;
    saveState(100, selected_led);
  }

  delayTime = loadState(101);
  if (delayTime > 240) {
    delayTime = 1;
    saveState(101, delayTime);
  }

  send_batteryTime = loadState(102);
  if (send_batteryTime > 250) {
    send_batteryTime = 1;
    saveState(102, send_batteryTime);
  }
  send_batteryTime = send_batteryTime * 10;

  boundary_DNlux = loadState(103);
  if (boundary_DNlux > 250) {
    boundary_DNlux = 0;
    saveState(103, boundary_DNlux);
  }

  selected_motion_mode = loadState(104);
  if (selected_motion_mode > 2) {
    selected_motion_mode = 0;
    saveState(104, selected_motion_mode);
  }
}



void presentation()
{
  sendSketchInfo("Motion Sensor", "1.2");
  wait(100);
  present(MOTION_SENS_ID, S_MOTION, "MOTION STATUS");
  wait(100);
  present(LUX_SENS_ID, S_LIGHT_LEVEL, "LUX LEVEL");
  wait(100);
  present(SETTING_LED_SENS_ID, S_CUSTOM, "LED MODE (R,G,B)");
  wait(100);
  present(DELAY_TIME_SENS_ID, S_CUSTOM, "DELAY TIME/MIN");
  wait(100);
  present(MOTION_MODE_ID, S_CUSTOM, "MOTION MODE (D|N|ALL");
  wait(100);
  present(SETTING_LUX_SENS_ID, S_LIGHT_LEVEL, "LUX MODE");
  wait(100);
  present(BATTARY_SEND_SENS_ID, S_CUSTOM, "BATTERY SEND TIME X10");
}


void setup()
{
  lightMeter.begin();
  readBatLev();
  wait(100);
  lux = lightMeter.readLightLevel();
  send(msg_lux.set(lux));
  wait(100);
  tripped = digitalRead(motion_pin);
  send(msg_motion.set(tripped));
  wait(100);
  send(msg_setting_led.set(selected_led));
  wait(100);
  send(msg_motion_mode.set(selected_motion_mode));
  wait(100);
  send(msg_setting_lux.set(boundary_DNlux));
  wait(100);
  send(msg_battary_send.set(send_batteryTime));
}


void loop()
{
  if (delayTime != 0) {
    if (sleep_mode == 0) {
      woke_up_from = sleep(digitalPinToInterrupt(motion_pin), RISING, delayTime * 60 * 1000, false);
    }
    if (sleep_mode == 1) {
      woke_up_from = sleep(digitalPinToInterrupt(motion_pin), RISING, delayTime * 60 * 1000, true);
      sleep_mode = 0;
    }
  } else {
    if (sleep_mode == 0) {
      woke_up_from = sleep(digitalPinToInterrupt(motion_pin), CHANGE, 0, false);
    }
    if (sleep_mode == 1) {
      woke_up_from = sleep(digitalPinToInterrupt(motion_pin), CHANGE, 0, true);
      sleep_mode = 0;
    }
  }
  if (flag != 1) {
    if (selected_motion_mode != 2) {
      lux = lightMeter.readLightLevel();
      if (selected_motion_mode == 0) {
        if (lux <= boundary_DNlux) {
          flag_motion_mode = 1;
        }
      } else {
        if (lux > boundary_DNlux) {
          flag_motion_mode = 1;
        }
      }
    } else {
      flag_motion_mode = 1;
    }
  }else{
   flag_motion_mode = 1; 
  }


  if (woke_up_from == 1) {
    if (flag_motion_mode == 1) {
      tripped = digitalRead(motion_pin);
      if (delayTime != 0) {
        if (flag == 0) {
          flag = 1;
          led_show_detect(selected_led, MYLED_ON);
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION: DETECTED\n"));
          send(msg_motion.set(1));
          TRANSPORT_DEBUG(PSTR("MyS: SEND STATUS TO GW\n"));
          if (count_batteryTime < send_batteryTime) {
            TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: %d, < %d\n"), count_batteryTime, send_batteryTime);
            count_batteryTime++;
          }
          else {
            readBatLev();
            count_batteryTime = 0;
            TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: 0\n"));
            if (selected_motion_mode == 2) {
              lux = lightMeter.readLightLevel();
              send(msg_lux.set(lux));
              TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
            } else {
              send(msg_lux.set(lux));
              TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
            }
            sleep_mode = 1;
          }
        }
        else {
          TRANSPORT_DEBUG(PSTR("MyS: UPDATE DELAY STATUS MOTION: DETECTED\n"));
        }
      } else {
        if (tripped == 0) {
          flag = 1;
          led_show_detect(selected_led, MYLED_OFF);
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION: NOT DETECTED\n"));
          send(msg_motion.set(0));
          TRANSPORT_DEBUG(PSTR("MyS: SEND STATUS TO GW\n"));
        } else {
          flag = 0;
          led_show_detect(selected_led, MYLED_ON);
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION: DETECTED\n"));
          send(msg_motion.set(1));
          TRANSPORT_DEBUG(PSTR("MyS: SEND STATUS TO GW\n"));
          if (count_batteryTime < send_batteryTime * 10) {
            TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: %d, < %d\n"), count_batteryTime, send_batteryTime);
            count_batteryTime++;
          }
          else {
            readBatLev();
            count_batteryTime = 0;
            TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: 0\n"));
            if (selected_motion_mode == 2) {
              lux = lightMeter.readLightLevel();
              send(msg_lux.set(lux));
              TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
            } else {
              send(msg_lux.set(lux));
              TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
            }
            sleep_mode = 1;
          }
        }
      }
      flag_motion_mode = 0;
    }
  }

  if (woke_up_from == -1) {
    if (flag == 0) {
      if (count_batteryTime < send_batteryTime) {
        count_batteryTime++;
        TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: %d, < %d\n"), count_batteryTime, send_batteryTime);
      }
      else {
        readBatLev();
        count_batteryTime = 0;
        TRANSPORT_DEBUG(PSTR("MyS: COUNTER BATTERY SEND: 0\n"));
        if (selected_motion_mode == 2) {
          lux = lightMeter.readLightLevel();
          send(msg_lux.set(lux));
          TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
        } else {
          send(msg_lux.set(lux));
          TRANSPORT_DEBUG(PSTR("MyS: LUX LEVEL SEND\n"));
        }
        sleep_mode = 1;
      }

    } else {
      flag = 0;
      led_show_detect(selected_led, MYLED_OFF);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION: NOT DETECTED\n"));
      send(msg_motion.set(0));
      TRANSPORT_DEBUG(PSTR("MyS: SEND STATUS TO GW\n"));
    }
    flag_motion_mode = 0;
  }
}


void receive(const MyMessage & message)
{
  if (message.sensor == SETTING_LED_SENS_ID) {
    if (message.type == V_VAR1) {
      if (message.getByte() <= 3) {
        selected_led = message.getByte();
        saveState(100, selected_led);
        send(msg_setting_led.set(selected_led));
        if (selected_led == 0) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION LED: OFF\n"));
        }
        if (selected_led == 1) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION LED: GREEN\n"));
        }
        if (selected_led == 2) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION LED: RED\n"));
        }
        if (selected_led == 3) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION LED: BLUE\n"));
        }
      }
    }
  }
  if (message.sensor == DELAY_TIME_SENS_ID) {
    if (message.type == V_VAR1) {
      if (message.getULong() <= 240) {
        delayTime = message.getULong();
        saveState(101, delayTime);
        send(msg_delay_time.set(delayTime));
        TRANSPORT_DEBUG(PSTR("MyS: THE NEW DELAY VALUE IS SET: %d MIN.\n"), delayTime);
      }
    }
  }
  if (message.sensor == BATTARY_SEND_SENS_ID) {
    if (message.type == V_VAR1) {
      if (message.getULong() <= 250) {
        send_batteryTime = message.getULong();
        saveState(102, send_batteryTime);
        send(msg_battary_send.set(send_batteryTime));
        send_batteryTime = send_batteryTime * 10;
        TRANSPORT_DEBUG(PSTR("MyS: THE NEW BATTERY TIME SEND IS SET: %d MOTION SENSOR OPERATIONS\n"), send_batteryTime);
      }
    }
  }

  if (message.sensor == MOTION_MODE_ID) {
    if (message.type == V_VAR1) {
      if (message.getByte() <= 2) {
        selected_motion_mode = message.getByte();
        saveState(104, selected_motion_mode);
        send(msg_motion_mode.set(selected_motion_mode));
        if (selected_motion_mode == 0) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION MODE: WORK IN THE DARK\n"));
        }
        if (selected_motion_mode == 1) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION MODE: WORK IN THE LIGHT\n"));
        }
        if (selected_motion_mode == 2) {
          TRANSPORT_DEBUG(PSTR("MyS: STATUS MOTION MODE: ALWAYS WORK\n"));
        }
      }
    }
  }
  if (message.sensor == SETTING_LUX_SENS_ID) {
    if (message.type == V_LEVEL) {
      if (message.getUInt() <= 250) {
        boundary_DNlux = message.getUInt();
        saveState(103, boundary_DNlux);
        send(msg_setting_lux.set(boundary_DNlux));
        TRANSPORT_DEBUG(PSTR("MyS: THE NEW BORDER LIGHT LUX IS SET: %d\n"), boundary_DNlux);
      }
    }
  }
}

void readBatLev() {
  wait(100);
  ADMUX = _BV(REFS1) | _BV(REFS0) | _BV(MUX2) | _BV(MUX1);
  wait(100);
  ADCSRA |= _BV(ADSC);
  while (bit_is_set(ADCSRA, ADSC));
  uint8_t low  = ADCL;
  uint8_t high = ADCH;
  long temp = (high << 8) | low;
  float vcc = temp * 1.1 / 1023 * BAT_COOF * 100;
  battery = map((int)vcc, BAT_MIN, BAT_MAX, 0, 100);
  if (battery < 0) {
    battery = 0;
  }
  if (battery > 100) {
    battery = 100;
  }
  TRANSPORT_DEBUG(PSTR("MyS: BATTERY LEVEL: %d, PREVIUS BATTERY LEVEL: %d\n"), battery, old_battery);
  if (first_send_battery == 1) {
    first_send_battery = 0;
    sendBatteryLevel(battery);
    TRANSPORT_DEBUG(PSTR("MyS: SEND BATTERY LEVEL\n"));
    old_battery = battery;
  } else {
    if (old_battery != battery) {
      if (battery < old_battery) {
        old_battery = battery;
        sendBatteryLevel(battery);
        TRANSPORT_DEBUG(PSTR("MyS: SEND BATTERY LEVEL\n"));
      } else {
        battery = old_battery;
      }
    }
  }
}


void led_show_detect(uint8_t led, uint8_t mode) {
  if (led == 1) {
    if (mode == 1) {
      digitalWrite(gled_pin, LOW);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED GREEN: ON\n"));
    } else {
      digitalWrite(gled_pin, HIGH);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED GREEN: OFF\n"));
    }
  }
  if (led == 2) {
    if (mode == 1) {
      digitalWrite(rled_pin, LOW);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED RED: ON\n"));
    } else {
      digitalWrite(rled_pin, HIGH);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED RED: OFF\n"));
    }
  }
  if (led == 3) {
    if (mode == 1) {
      digitalWrite(bled_pin, LOW);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED BLUE: ON\n"));
    } else {
      digitalWrite(bled_pin, HIGH);
      TRANSPORT_DEBUG(PSTR("MyS: STATUS LED BLUE: OFF\n"));
    }
  }
}

```

additional library: 
[BH1750](https://majordomo.smartliving.ru/forum/download/file.php?id=11067&sid=d7be670658785dade7f13cb1ea0e9a1c)




**List of components that are present at the sensor:**


PCB - $0,74

Battery holder 4 pcs. - $2,15
http://ali.ski/0j22k8

Quartz 8 MHz - $0,38
http://ali.ski/3wpZcC

Buttons clocks cm 2 pieces - $0,21
http://ali.ski/TIXuLK

The Fresnel lens - $0,27
http://ali.ski/PyfAb

Connector 2x3 P6 1.27mm 2 pcs - $0,27
http://ali.ski/2GRtq

NRF24L01 - $1,00
http://ali.ski/Jx3z00

Condenser 100nf 8 pieces - $0,15
http://ali.ski/ctayFM

BH1750FVI-TR - $1,36
http://ali.ski/d9RYX5

TPS62745DSSR - $1,43
http://ali.ski/wD_r6G

AM312 - $1,62
http://ali.ski/ZqJSAW

Atmega328p-au - $2,28
http://ali.ski/B2JbY

Atsha204a-stucz-t - $0,97
http://ali.ski/88sem_

RGB SMD 0805 (2012) - $0,07
http://ali.ski/GxnHju

Condenser 10uf 25v 1206 XTR7 - $0,09
http://ali.ski/RiAZ8F

Condenser 10uf 16v 1206 XTR5 - $0,01
http://ali.ski/1OQW2

Inductance 4.7uh 1210 - $0,71
http://ali.ski/JC2n1

AT25F512B-SSH-T - $0,09
http://ali.ski/vfpdL

Condenser tantalum 1uf 16v 0805 - $0,37
http://ali.ski/CHz126

Switch dsc0011 smd - $0,01
http://ali.ski/acHKDe

Resistors 10K 1% 0805 6 pieces - < $0,01
http://ali.ski/i1tnsM

Resistors 1M 1% 0805 1 piece - < $0,01
http://ali.ski/i1tnsM

Resistors 160K 1% 0805 1 pcs. - < $0,01
http://ali.ski/i1tnsM

Resistors 11K 1% 0805 1 piece - < $0,01
http://ali.ski/i1tnsM

Resistors 27K 1% 0805 1 piece - < $0,01
http://ali.ski/i1tnsM

**Total: $14.27**