# Arduino Pro Mini Shield for RFM69

PCB suitable for hosting Arduino Pro Mini + RFM69 radio projects. Provides full breakout pins, each coupled with Vcc and Gnd, so the board can be used for when many sensors need to be connected or just for developing/testing a new complex project.

## Features

* Small footprint (37x68 mm)
* Terminal block for connecting Gnd and Vcc (3.3v)
* Breakout pins for each pin of the Arduino (through J4 and J5 pin headers)
* When jumpers JP1, JP2, JP3 and JP4 are shorted, each of the Arduino's pins header will have its own Vcc (J2 and J7) and Gnd (J3 and J6). If not shorted, J2, J3, J6 and J7 can be used as prototyping area (please note all the pins of each pin header are connected together). For example I2C's SDA and SDL can be connected to one of the pin of a connector allowing multiple sensors to be connected to the other pins
* In order for the RFM69 radio to work, jumper JP5 has to be shorted. If not, the radio will be disconnected (useful in case you need to use the SPI pins)
* Capacitor for RFM69 radio and SMA connector for the antenna
* Available a 4x3 prototyping area (J9, J10 and J11)

## Changelog
Revision 1:
* First release