This is a PCB for all beginners who want to quickly build the nodes described in the [MySensors website](https://www.mysensors.org/build/connect_radio)! It can be used with regulated power or batteries and only have basic components.
Its a PCB for all newbies that want to do basic sensor/actuator nodes like myself out there...

**This is the RFM69(HW/W) edition of EasyPCB!**
If you want the original EasyPCB with Nrf24l01+ transceiver - [go here](https://www.openhardware.io/view/4).

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/EasyRFMRev10_Overview.jpg "enter image title here")

## **Why?**

So pretty much this PCB covers all the basic stuff documented in the [MySensors website](https://www.mysensors.org/build/connect_radio)! This cuts my work with one node from a couple of hours (soldering wires) to 20min.

## **What?**

Only easy to solder components with good space in between.
Only basic functions (Pro Mini 3,3v, Radio, Input for sensors and if battery powered booster and voltage divider)
Some inputs for all the normal sensors used in the build section.
5x5 or 3x5 depending on function and dynamic in what power you use (Battery, 3.3v or >3.3v (requires voltage regulator). 
Note, this edition can only handle Pro Mini 3.3v and NOT 5v

## **How?**

## _Battery (2xAA or similar)_

5x5cm

- [Arduino Pro Mini 3.3V](https://www.mysensors.org/store/arduinos)
- [Radio RFM69 H or HW](https://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- [Voltage divider - Measuring and Reporting Battery Level](http://www.mysensors.org/build/battery#measuring-and-reporting-battery-level) [- (My code)](https://github.com/sundberg84/MySensors2.0.0/blob/master/BatteryMeasurer/BatteryMeasurer.ino)
- [Boost converter/step-up converter](https://www.mysensors.org/store/regulators) (0.9 - 3v > 3.3v) (Use a good quality booster! Cheap boosters create a lot of noise which can interfere with radio and other components. Alternative build without the booster and lower BOD)
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use BAT jumper and make sure you have a booster attached to close the circuit. Connect the batteries to right input marked "<= 3.3v" 

Power consumption (without booster) in MySensors sleep() mode (Ver 2.2) was measured to 5,2uA which will last a node (depending on how often it transmits) a long time!

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/EasyRFMRev10_Battery.jpg "enter image title here")
## _Regulated 3.3v_

3x5cm (cut PCB)

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use REG jumper and connect 3.3v to right input marked "<= 3.3v"

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/EasyRFMRev10_Reg3p3v.jpg "Reg 3,3v")

_Only the lower capacitor marked 0.1uF affects the RFM69 module! The capacitor marked 10uF only affects the input of the voltage regulator._

## _Higher voltage than 3.3v_

3x5cm (cut PCB)

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Voltage regulator to handle your input voltage and regulate it down to 3.3v
- Nu jumper should be connected and connect your power to left input marked "> 3.3v"

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/EasyRFMRev10_MoreThan3p3v_bak.jpg "enter image title here")

## _Battery without a step-up booster (advanced users)_
3x5cm (cut PCB)

**To be able to achieve this you need to reprogram the atmega bootloader/fuses and lower the BOD!**

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use REG jumper and connect 3.3v to right input marked "<= 3.3v"

With REG closed you will feed everything (Arduino, Radio and Sensors) with whatever voltage the battery holds. You can´t use any sensors which require higher voltage than the current battery status (without using a DC/DC Step up booster for the sensor). With this configuration, you can measure VCC supply level without external components [[Library](https://github.com/Yveaux/arduino_vcc)]. Lowest working voltage (depending on added sensors) will probably be the RFM69w module which can handle down to 1.8v. Do not use any DC/DC step-up booster or voltage regulator to feed the Arduino or radio!

To lower BOD you can use standard Pro Mini bootloader and change boards.txt. [See here for instructions.](https://forum.mysensors.org/topic/7296/burning-fuses/8). This will give you some more battery (down to 2.2-2.4v?) but use the 8mhz external crystal at lower voltages will be risky (at least at 1.8v, radio minimum) so it might be a good idea to run a [bootloader @ 1mhz internal oscillator](https://forum.mysensors.org/topic/3018/tutorial-how-to-burn-1mhz-8mhz-bootloader-using-arduino-ide-1-6-5-r5).

## Build video

- [A great video](https://www.youtube.com/watch?v=N4u6jlIVNGE) by [@wez](https://forum.mysensors.org/user/wes) on how to assemble the EasyPCB with Booster and Battery (timelapse). A good example on how to build modular which allows to remove or change hardware if something goes wrong/stops working or you just want to re-use the sensor in the future for something else. 

- [A build video of a regulated 5v EasyPCB (nrf24l01+)](https://youtu.be/CNtBzNdDGdY), including uploading a sketch for testing the radio and clearing the EEPROM.

- More videos can be found looking at the [Nrf24l01+ version](https://www.openhardware.io/view/4). Its the same build except for another radio.

## Antenna

You need to attach an antenna to the board. The antenna needs to be single core inside, not multi-wire like you can find in common dupont cable. Aside from not working without an antenna, transmitters can be damaged if they transmit without an antenna present. For this PCB you can either attach an SMA connector and buy an antenna with that connector or make do it yourself. There are a lot of tutorials out there, and for 433mhz I suggest [this tutorial](https://arduinodiy.wordpress.com/2015/07/25/coil-loaded-433-mhz-antenna/).

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/antenna.JPG "enter image title here")

## PCB Dimensions

5x3,5cm for cut PCB/regulated voltage and 5x5cm battery operations with extra prototyping space.

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/EasyRFMRev10_BoardSize.jpg "enter image title here")

## Jumpers

- BAT: Short this if you are using batteries as power supply. It will activate booster circuit and power everything with a stable 3.3v. Make sure you have a corresponding DC/DC step-up booster to match your batteries to 3.3v

- REG: Use this if you are using 3.3v regulated DC. 

- RAW: This is a [MysX feauture](https://www.mysensors.org/hardware/mysx#mysx-20). This cuts onboard Vraw source if daughterboard provides Vraw. This is only used when EasyPCB is connected to a daughterboard.

## MysX 2.4
This is [The MySensors expansion connector](https://www.mysensors.org/hardware/mysx) to which you can connect any daughterboard using this standard. This is also your main input/outputs for sensors and actuators so any wires can be connected accordingly. With this PCB as motherboard, you can use draughtboards if you need multiple copies and needs a quicker way to build - just like a shield on Arduino or Raspberry Pi.

If you want to create your own MysX daughterboard you can use [this template](https://github.com/sundberg84/HomeAutomation/tree/master/MysX%20template%20EasyPCB) (KiCad)

#### Example
- [Door sensor/Reed switch](https://forum.mysensors.org/topic/7836/what-did-you-build-today-pictures/321)
- [MysX-Dimmable-Led-board](https://www.openhardware.io/view/552/MysX-Dimmable-Led-board)

## **Revision changes**

2018-06-05
Rev 10 - RFM69 Edition
- MysX location changed to accept more MysX boards and align like Nrf24 version.
- Antenna location changed, radio rotated 180 degrees
- Optional signing chip added
- Optional SPI flash added.
- Extra pins aligned to 2.45 vertical & horizontal
- Relocated Extra + Bat Measurer some to allow more space to booster
- Pinholes added for RFM Radio
- Changed pull-up resistor from D3 to D5 to have one more pin for Interrupt

## **I want it!**

- Order 10pcs: [Openhardware.io](https://www.openhardware.io/order/389/PCB10X) (Recommended!) and support me and MySensors! 
_(It may say another rev. at the order page but this is not EasyPCB rev but the rev for the manufacturer. I always update the Gerber files for sale! Current = Rev 10)_

- Download from this page to get KiCad and Gerber files. 

- If you want a faster shipping time or fewer pieces you can [order from me on Ebay](https://www.ebay.com/itm/223479430798). 

## Inspiration
https://1drv.ms/f/s!Ak7D1EWM7GXggvQ9mzJzWJSMir8sLA

_(Note some photos are older revisions of the PCB)_

## ** Projects **

- [Serial Gateway](https://forum.mysensors.org/topic/6809/easy-newbie-pcb-rfm69-hw-w-edition-for-mysensors/16)
- [Garden beer cooler](https://forum.mysensors.org/topic/6809/easy-newbie-pcb-rfm69-hw-w-edition-for-mysensors/29)
- [Portable RFM69 Signal Scanner](https://forum.mysensors.org/topic/7822/portable-rfm69-signal-scanner)
- [BME280 (i2c - Humidity/Pressure/temp) nodes](https://forum.mysensors.org/assets/uploads/files/1518948568991-my-easypcb-3.jpg)
- [Irrigation controller](https://forum.mysensors.org/topic/6598/battery-powered-irrigation-controller/36)
- [Finger print reader (battery)](https://forum.mysensors.org/topic/9411/battery-powered-fingerprint-reader)
- [Bedside alarm clock](https://forum.mysensors.org/topic/9444/clock-with-temperature-humidity-and-co2-level-sensors)
- [Door + Flood sensor](https://forum.mysensors.org/topic/9522/door-flood-sensor)

## Ebay Link

