This is a PCB for all beginners who want to quickly build the nodes described in the [MySensors website](https://www.mysensors.org/build/connect_radio)! It can be used with regulated power or batteries and only have basic components.
Its a PCB for all newbies that wants to do basic sensor/accuator nodes like myself out there... :)

**This is the RFM69(HW/W) edition of EasyPCB!**
If you want the original EasyPCB with Nrf24l01+ transiever - [go here](https://www.openhardware.io/view/4).

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/schematics.jpg "enter image title here")

## **Why?**

So pretty much this PCB covers all the basic stuff documented in the [MySensors website](https://www.mysensors.org/build/connect_radio)! This cuts my work with one node from a couple of hours (soldering wires) to 20min.

## **What?**

Only easy to solder components with good space in between.
Only basic functions (Pro Mini 3,3v, Radio, Input for sensors and if battery powered booster and voltage divider)
Some inputs for all the normal sensors used in the build section.
5x5 or 3x5 depending on function and dynamic in what power you use (Battery, 3.3v or >3.3v (requires voltage regulator). 
Note, this edition can only handle Pro Mini 3.3v and NOT 5v

## **How?**

## _Battery (2xAA or similar)_

5x5cm

- Pro Mini 3.3V
- [Radio RFM69 H or HW](https://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- [Voltage divider - Measuring and Reporting Battery Level](http://www.mysensors.org/build/battery#measuring-and-reporting-battery-level)
- DC/DC Step up booster (0.9 - 3v > 3.3v)
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use BAT jumper and make sure you have a booster attached to close the circiut. Connect the batteries to right input marked "<= 3.3v" 

Power consumption (without booster) in MySensors sleep() mode (Ver 2.2) was measured to 5,2uA which will last a node (depending on how often it transmits) a long time!

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/battery.jpg "enter image title here")

## _Regulated 3.3v_

3x5cm (cut PCB)

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use REG jumper and connect 3.3v to right input marked "<= 3.3v"

![](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/33regpower.jpg "enter image title here")
_Only the lower capacitor marked 0.1uF affects the RFM69 module! The capacitor marked 10uF only affects the input of the voltage regulator._

## _Higher voltage than 3.3v_

3x5cm (cut PCB)

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Voltage regulator to handle your input voltage and regulate it down to 3.3v
- Nu jumper should be connected and connect your power to left input marked "> 3.3v"

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/MoreThan33volt.jpg "enter image title here")

## _Battery without step up booster (advanced users)_
3x5cm (cut PCB)

**To be able to achieve this you need to reprogram the atmega bootloader/fuses and lower the BOD!**

- Pro Mini 3.3v
- [Radio RFM69 H or HW](http://www.mysensors.org/build/connect_radio#rfm69-&-arduino)
- Antenna
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- Use REG jumper and connect 3.3v to right input marked "<= 3.3v"

With REG closed you will feed everything (Arduino, Radio and Sensors) with whatever voltage the battery holds. You can´t use any sensors which require higher voltage than the current battery status (without using a DC/DC Step up booster for the sensor). With this configuration you can measure VCC supply level without external components [[Library](https://github.com/Yveaux/arduino_vcc)]. Lowest working voltage (depending on added sensors) will probably be the RFM69w module which can handle down to 1.8v. Do not use any DC/DC step up booster or voltage regulator to feed the Arduino or radio!

To lower BOD you can use standard Pro Mini bootloader and change boards.txt. [See here for instructions.](https://forum.mysensors.org/topic/7296/burning-fuses/8). This will give you some more battery (down to 2.2-2.4v?) but using the 8mhz external crystal at lower voltages will be risky (atleast at 1.8v, radio minimum) so it might be a good idea to run a [bootloader @ 1mhz interal oscillator](https://forum.mysensors.org/topic/3018/tutorial-how-to-burn-1mhz-8mhz-bootloader-using-arduino-ide-1-6-5-r5).

## Antenna

You need to attach an antenna to the board. The antenna needs to be single core inside, not multi-wire like you can find in common dupont cable. Aside from not working without an antenna, transmitters can be damaged if they transmit without an antenna present. For this PCB you can either attach a SMA connector and buy an antenna with that connector or make do it yourself. There are alot of tutorials out there, and for 433mhz i suggest [this tutorial](https://arduinodiy.wordpress.com/2015/07/25/coil-loaded-433-mhz-antenna/).

![enter image description here](https://www.openhardware.io//uploads/5912c78ca2d1ad3029004702/image/antenna.JPG "enter image title here")

## Jumpers

- BAT: Short this if you are using batteries as power supply. It will activate booster circuit and power everything with a stable 3.3v. Make sure you have a corresponding DC/DC step up booster to match your batteries to 3.3v

- REG: Use this if you are using 3.3v regulated DC. 

- RAW: This is a [MysX feauture](https://www.mysensors.org/hardware/mysx#mysx-20). This cuts onboard Vraw source if daughterboard provides Vraw. This is only used when EasyPCB is connected to a daugheterboard.

## **Revision changes**

Rev 9 - RFM69 Edition
- Everything Remodeled in KiCad (with same purpose - EASY and Newbie board!)
- This edition uses transiever RFM69 H/HW (and not Nrf24l01+ as other rev).
  - Major changes in routing due to this.
- Some changes in power due to 3.3v RFM69 inputs tolerance.
  - Note, this edition can only handle Pro Mini 3.3v and NOT 5v.
- Changed capacitor silkmask (now round, easier to understand)
- Added external antenna connector (SMA and DIY connector)
- Appearance might be different in this edition due to move from Eagles to CAD.

**20/7-2017 This PCB is still under development and testings! Its far from finished and comfirmed working**

## **I want it!**

- Order 10pcs: [Openhardware.io](https://www.openhardware.io/order/389/PCB10X) (Recommended!) and support me and MySensors! 
_(It may say another rev. at the orderpage but this is not EasyPCB rev but the rev for manufacturer. I always update the gerber files for sale! Current = Rev 9)_

- Download from this page to get KiCad and Gerber files. 

- If you want a faster shipping time or less pieces you can [order from me on Ebay](http://www.ebay.com/itm/-/222632888717?).

## ** Projects **

- [Serial Gateway](https://forum.mysensors.org/topic/6809/easy-newbie-pcb-rfm69-hw-w-edition-for-mysensors/16)
- [Garden beer cooler](https://forum.mysensors.org/topic/6809/easy-newbie-pcb-rfm69-hw-w-edition-for-mysensors/29)