# jModule2

---
Extension module with Arduino Pro Mini connected with nRF24L01 radio.

---
The goal of this project is to create a module for further use with "mySensors".
The module must be as small as possible, easy to build and cheap.


## Build instruction 

Prepare elements:
  - jBoard2
  - Arduino Pro Mini compatible board
  - nRF24L01 radio
  - LE33 voltage regulator
  - 4,7uF capacitor
  - 1x4 angular female header
  - 1x4 extended pin header
  - 1x8, 1x2 angular pin headers


![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/step1.jpg "Build instruction setp1 - step6")

1. Solder 1x4 angular female header to jBoard2. Solder it from the top side of the board.
2. Cut off nRF24l01 radio pin headers - leave them 0.8mm long (the jBoard2 thickness). Keep 5 of the cut-of pin headers - they will be used for step 6.
3. Solder the radio to jBoard2. The 1x4 angular female header should be between the jBoard2 and the radio.
4. Solder LE33 voltage regulator to jBoard2. Cut off protruding pin headers as close to the board as possible and smooth the headers. If you use 3v Arduino Pro Mini skip this step. Instead of this make a connection between Vin and Vout pads for the regulator on the jBoard2.
5. Solder 4,7uF capacitor to jBoard2. Cut off only VCC protruding pin header as close to the board as possible and smooth the header. **Do not cut off GND pin header!**
6. Solder the cut-of pin headers from step 2 to jBoard2. Solder them from the top side of the board.![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/step3.jpg "Build instruction setp7 - step12")
7. Replace 4 angular pin headers with the extended ones. If you do not need analogue outputs replace only the first angular pin header. Next bend the fist replaced header - see picture above.  
8. Cut off extended pin header/s, leave them 15mm long - see picture above.
9. Plug in the connector to the 1x4 female header.
10. Using an adhesive tape make an electrical insulation. Secure all Arduino Pro Mini pads which could connect to jBoard2 pads.
11. Solder 1x2 angular pin header to Arduino Pro Mini.
12. Combine Arduino Pro Mini with the jBoard2 and solder them.

![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/jModule2.jpg "jModule2")

Done :). The module is ready to talk with your "sensor projects". 
- 8 IO pins(A1...A3, 5...9) plus one GND pin and one VCC pin are located on one side.
- Only a 1x8 female header on the edge of your board and 2 wires from a power supply are needed to use the module.
- Easy to access serial interface for programming.

## Important note
![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/i_note.jpg "enter image title here")

## Alternative build option
![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/a_step1.jpg "enter image title here")

1. Solder 1x4 angular female header to jBoard2. Solder it from the bottom side of the board, it should stick out the board.
2. Remove a plastic distance from nRF24L01 radio.
3. Solder the radio to jBoard2. Cut off nRF24l01 radio pin headers and smooth the headers. Keep 5 of the cut-of pin headers - they will be used for step 6.
4. Solder LE33 voltage regulator to jBoard2. Cut off protruding pin headers and smooth the headers. If you use 3v Arduino Pro Mini skip this step. Instead of this make a connection between Vin and Vout pads for the regulator on the jBoard2.
5. Solder 4,7uF capacitor to jBoard2. Cut off protruding pin headers and smooth the headers.
6. Solder the cut-of pin headers from step 2 to jBoard2. Solder them from the bottom side of the board.![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/a_step4.jpg "enter image title here")
7. Replace 4 angular pin headers with the extended ones. If you do not need analogue outputs replace only the first angular pin header. Next bend the fist replaced header - see picture above.  
8. Cut off extended pin header/s, leave them 15mm long - see picture above.
9. Plug in the connector to the 1x4 female header.
10. Solder 1x2 angular pin header to Arduino Pro Mini.
11. Combine Arduino Pro Mini with the jBoard2 and solder them.
12. Using a wire connect GND pads. The dotted line - if your Arduino Pro Mini does not have an extra GND pad.

![enter image description here](https://www.openhardware.io//uploads/5891e16e6abbef590529043a/image/alternative_jModule2.jpg "enter image title here")

Done :). The module is ready to talk with your "sensor projects". 
- 8 IO pins(A1...A3, 5...9) plus one GND pin and one VCC pin are located on one side.
- Only a 1x8 female header on the edge of your board and 2 wires from a power supply are needed to use the module.
- Easy to access serial interface for programming.