This is a Wemos shield for a dipole RFM69HW module.  Earlier in the year I lashed together an ESP8266 ESP-13 and an RFM69HW to serve as a gateway.  It works great (see photo).  Two things to notice: the compact footprint and the dipole antenna.  The dipole antenna yields a significant improvement in antenna performance over using just a typical wire monopole antenna coupled to a typically undersized ground plane. 

Connections are to be as follows:

RFM69HW <--> ESP8266 <--> Wemos D1 Mini

SCK <--> GPIO14 <--> D5

MISO <--> GPIO12 <--> D6

MOSI <--> GPIO13 <--> D7

NSS <--> GPIO15 <--> D8

DIO00 <--> GPIO04 <--> D2

GND <--> GND <--> GND

3.3V <--> 3.3V <--> 3.3V

With these connections, it should be possible from within the Arduino IDE to program the Wemos D1 Mini to utilize the RFM69HW directly, without involving an atmega328p.  As an added bonus, you can also wirelessly update your sketch from within the Arduino IDE as well, provided you modify your initial sketch in accordance with the example sketch given in the Ardiuno IDE for doing ESP8266 OTA wireless updates.  Because of the ESP8266's Wi-Fi wireless connectivity, this should make for an excellent, easily portable, inexpensive, and easy-to-update gateway node.

For reference, here's a pinout of the Wemos D1 Mini:
![alt text](http://esp8266.uelectronics.info/wp-content/uploads/sites/14/2016/08/D1-mini-pinout-Page-1.png)

I have built similar nodes in the past based on an ESP-13, a nodeMCU, and an Adafruit Huzzah! ESP8266.  Each of them worked very well, but I think an RFM69HW node based on a Wemos D1 Mini shield will be the easiest for most people to both make and utilize.

Note:  the same shield can, of course, also be used in a monopole antenna configuration simply by not installing the GND antenna.




