# jModule

---
Extension module with Arduino Pro Mini connected with nRF24L01 radio.

---
The goal of this project is to create a module for further use with "mySensors".
The module must be as small as possible, easy to build and cheap.


**Build instruction **

1. First prepare all needed elements:
  - jBoard
  - Arduino Pro Mini compatible board
  - nRF24L01 radio
  - AMS1117 voltage regulator
  - 4,7uF capacitor
  - 1x9, 1x2, 1x1 goldpin headers
  - 1x6, 1x6, 1x2 angular goldpin headers

 <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0051.jpg" width="500" height="300">
 
2. Solder AMS1117 voltage regulator to jBoard. If you use 3v Arduino Pro Mini skip this step. Instead of this make a connection between Vin and Vout pads for the regulator on the jBoard.

 <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0057.jpg" width="500" height="300">

3. Solder 1x6 angular goldpin header to jBoard.

 <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0059.jpg" width="500" height="300">

4. Solder 1x2 and 1x1 goldpin headers to jBoard.

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0061.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0064.jpg" width="500" height="300">

5. Solder 1x9 goldpin header to jBoard.

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0066.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0068.jpg" width="500" height="300">

6. Smooth goldpin headers.

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0072.jpg" width="500" height="300">

7. Remove a plastic distance from nRF24L01 radio and using an adhesive tape make an electrical insulation.

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0076.jpg" width="500" height="300">

8. Solder nRF24L01 module and decoupling capacitor to jBoard. Cut off protruding headers. 

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0082.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0086.jpg" width="500" height="300">

9. Solder 1x2 and 1x6 angular goldpin headers to Arduino Pro Mini (RAW, GND and 3...8 pins).

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0089.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0091.jpg" width="500" height="300">

10. Solder jBoard to Arduino Pro Mini. Cut off protruding goldpin headers and next smooth the headers. 

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0092.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0098.jpg" width="500" height="300">

11. Done :). The module is ready to talk with your "sensor projects". 
  - 10 IO pins(3...8, A0...A3) plus one GND pin and one VCC pin are located on one side. 
  - Only a 2x6 female goldpin header on the edge of your board and 2 wires from a power supply are needed to use the module. 
  - Easy to access serial interface for programming.

  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0130.jpg" width="500" height="300">
  <img src="https://www.openhardware.io//uploads/56a75e5f2ae7c5aa0478de8b/image/IMAG0125.jpg" width="500" height="300">



