This is a PCB that tries to solve power from AC mains and run a standard MySensors node.

### **WHY?? - Aim of this project**

Power is sometimes a issue in DIY home automation. Battery operation in all its glory but sometimes we need to power a node 100% and why not use what we have. 240/120AC runs in all our homes today and this project aims for converting AC to 5vDC with safety as priority #1

- Convert 240v/120v AC to 5v DC (using HLK-PM01)

- Make it safe!

- Fit inside standard [appliance box](http://www.elko.se/getfile.php/produkter/img/3/3/4944/Foto4944.jpg) / in wall

- Run MySensors node (Arduino Pro Mini, NRF24L01+, MysX Gpio for sensors)

- If possible, add a SSR (Solid State Relay).

### How ?
By using the HLK-PM01, this PCB, An Arduino pro mini 5v and the NRF24 radio you have everything you need for a AC powered MySensors node. See BOM for all components.

- BOM/Instructions (3.1 - through hole components): http://1drv.ms/1kCzue5
- Build images (3.1 - through hole components): http://1drv.ms/1lsleox 
- Images/Inspiration (3.1 - through hole components): http://1drv.ms/1NvxATF

### **Current Status 19/3-2016**

*Rev 3*
- Rev3 PCB testing.
- Rev3.1 PCB released with AC circuit improvement.
- Not developed further.

*Rev 4*
- 3d printed case testing and evaluating.
- Rev 4 testing (SMD components, smaller height).
- Result is not 100% satisfying, proceeding with Rev 5 for SMD.

*Rev 5*
- PCB development from Rev 4

### **Safety**
Im aware of the big security risk here, and have tried to read:

- http://forum.mysensors.org/topic/1607/safe-in-wall-ac-to-dc-transformers

- http://forum.mysensors.org/topic/1540/110v-230v-ac-to-mysensors-pcb-board

- [Performance test and review of mains to 5V 0.6A Hi-Link HLK-PM01](http://lygte-info.dk/review/Power%20Mains%20to%205V%200.6A%20Hi-Link%20HLK-PM01%20UK.html)

- https://skippy.org.uk/quick-look-at-the-hlk-pm01/

- https://www.ieee.li/pdf/essay/safety_considerations_in_power_supply_design.pdf

### **Temperature in closed compartment**
![Temp](https://www.openhardware.io//uploads/5693e2ffaab2635a049184d5/image/rename.jpg "enter image title here")

### **Questions needing answers**

- Reliability, when will it fail? (compared to a commersial product?)
- How will it fail? What is it weakest point?
- Will my safety components be enough and prevail damage... ?
- What will happen when it fails?

-----

-----

### **If you are using this design, please know about the risks when you work with high power. **

### **This design has no guarantee s so use it on your own risk!**

-----

-----

![enter image description here](https://www.openhardware.io//uploads/5693e2ffaab2635a049184d5/image/20160119_213733.jpg "enter image title here")
