This is a PCB for all beginners who want to quickly build the nodes described in the [MySensors website](https://www.mysensors.org/build/connect_radio)! It can be used with regulated power or batteries and only have basic components.
Its a PCB for all newbies that want to do basic sensor/actuator nodes like myself out there... :)

**This is the Nrf24l01+ edition of EasyPCB!**
If you want to use RFM69 transceiver instead [go here](https://www.openhardware.io/view/389/EasyNewbie-PCB-RFM69-HWW-edition-for-MySensors).
![enter image description here](https://www.openhardware.io//uploads/568ed84b60aa3f8965fbf095/image/EasyNrfRev10_Overview.jpg "enter image title here")

## **Why?**

So pretty much this PCB covers all the basic stuff documented in the [MySensors website](https://www.mysensors.org/build/connect_radio)! This cuts my work with one node from a couple of hours (soldering wires) to 20min.

## **What?**

Only easy to solder components (bigger components with legs)
Only basic functions (Pro Mini, Radio, Input for sensors and if battery powered booster and voltage divider)
Dynamic in what power you use (Battery, 5v or Raw pin).
Some inputs for all the normal sensors used in the build section.
5x5 or 3x5 depending on the function

## **How?**

## _Battery 3.3v_
5x5cm

The design is the design from by my forum post [here ](http://forum.mysensors.org/topic/618/how-to-wire-battery-sensor-with-battery-voltage-reports)but also much cred to [@m26872](http://forum.mysensors.org/user/m26872) [My 2Aa battery sensor design](http://forum.mysensors.org/topic/486/my-2aa-battery-sensor).

- [Arduino Pro Mini 3.3V](https://www.mysensors.org/store/arduinos)
- [Radio with 4.7uf Cap](http://www.mysensors.org/build/connect_radio)
- [Voltage divider - Measuring and Reporting Battery Level](http://www.mysensors.org/build/battery#measuring-and-reporting-battery-level) [- (My code)](https://github.com/sundberg84/MySensors2.0.0/blob/master/BatteryMeasurer/BatteryMeasurer.ino)
- [Boost converter/step-up converter](https://www.mysensors.org/store/regulators) (0.9 - 3v > 3.3v)
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- BAT jumper should be soldered.
- [Remove Pro Mini voltage regulator and led/resistor.](https://forum.mysensors.org/topic/2740/easy-newbie-pcb-for-mysensors/296)

Please, note that different radio clones behave differently depending on noise from the booster. A good quality booster is important or you might have to modify and test different input caps on the radio and/or try to filter the booster with a different capacitor. A normal behaviour can be that you have to change the 4.7uF capacitor to a 47uF capacitor on the radio for example. I'm going to do more testing in this area to provide some more advice soon.

![enter image description here](https://www.openhardware.io//uploads/568ed84b60aa3f8965fbf095/image/EasyNrfRev10_Bat.jpg "enter image title here")


## _Regulated 5v_
3x5cm (cut PCB)

- Pro Mini 5v
- [Radio with 4.7uf Cap](http://www.mysensors.org/build/connect_radio)
- 5v -> 3.3v Regulator with caps
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)
- REG jumper should be soldered.

![enter image description here](https://www.openhardware.io//uploads/568ed84b60aa3f8965fbf095/image/EasyNrfRev10_Reg5v.jpg "enter image title here")

(If you are using regulated 3.3v, use  5v instructions but skip the voltage regulator and bypass this with a jumper between Vin and Vout

## _6-12v to RAW pin_
3x5cm (cut PCB)

- Pro Mini 5v
- [Radio with 4.7uf Cap](http://www.mysensors.org/build/connect_radio)
- 5v -> 3.3v Regulator with caps
- Caps/Resistors/Pinhead (jumper)/Screw terminal (optional)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)

Input 6-12V to RAW (right pin - not VCC!) and the voltage regulator onboard the Arduino Pro Mini will regulate it down to 5v. You also need the 5 to 3.3v voltage regulator with capacitors to power the radio. Nu jumper needs to be shorted.

Be careful using 12v to RAW on the cheap Arduino clones! Due to bad/cheap voltage regulators on the clones, many fail pretty fast. If you want to use 12v I would recommend using a genuine pro mini or regulate the voltage yourself and not let the clone do it.

## _Battery without step up booster (advanced users)_
3x5cm (cut PCB)

**To be able to achieve this you need to reprogram the atmega bootloader/fuses and lower the BOD!**

- Pro Mini 3.3V
- [Radio with 4.7uf Cap](http://www.mysensors.org/build/connect_radio)
- Sensors are possible to attach to the left (Gnd x 2, VCC, D3 (with or w.o resistor), D4, D5, A4, A5)

- Both REG and BAT jumper should be soldered.
- Feed the PCB with 2xAA (or similar) to VCC

With both REG and BAT closed you will feed everything (Arduino, Radio and Sensors) with whatever voltage the battery holds.
You can not use any sensors which require higher voltage than the current battery status (without DC/DC Step up booster).
With this configuration, you can use the internal VCC library to read battery status on VCC.
Lowest working voltage (depending on added sensors) will probably be the radio which can handle down to 1.9v. Do not use any DC/DC step-up booster or voltage regulator!

To lower BOD you can use standard Pro Mini bootloader and change boards.txt. [See here for instructions.](https://forum.mysensors.org/topic/7296/burning-fuses/8). This will give you some more battery (down to 2.2-2.4v? due to 8mhz) but use the 8mhz external crystal will be risky at low voltages (at least at 1.9v, radio minimum) so it might be a good idea to run a [bootloader @ 1mhz internal oscillator](https://forum.mysensors.org/topic/3018/tutorial-how-to-burn-1mhz-8mhz-bootloader-using-arduino-ide-1-6-5-r5).

## Build video

- [A great video](https://www.youtube.com/watch?v=N4u6jlIVNGE) by [@wez](https://forum.mysensors.org/user/wes) on how to assemble the EasyPCB (RFM radio, but otherwise the same!) with Booster and Battery (timelapse). A good example on how to build modular which allows to remove or change hardware if something goes wrong/stops working or you just want to re-use the sensor in the future for something else. 

- [A build video of a regulated 5v EasyPCB (nrf24l01+)](https://youtu.be/CNtBzNdDGdY), including uploading a sketch for testing the radio and clearing the EEPROM.

- [Me creating a LED-Strip using the EasyPCB](https://www.youtube.com/watch?v=SdD6Ozf80bk&t=46s)

- [EasyPCB on 2xAA batteris (Temp node)](https://www.youtube.com/watch?v=TxzvhG4uo9I&t=20s)

## PCB Dimensions 
5x3cm for cut PCB/regulated voltage and 5x5cm battery operations with extra prototyping space.

![enter image description here](https://www.openhardware.io//uploads/568ed84b60aa3f8965fbf095/image/EasyNrfRev10_BoardSize.jpg "enter image title here")

## Jumpers

- BAT: Short this if you are using batteries as power supply. It will activate booster circuit and feed the radio directly from the batteries and not the voltage regulator

- REG: Use this if you are using 5v regulated DC. It will power the radio from the voltage converter.

- RAW: This is a [MysX feauture](https://www.mysensors.org/hardware/mysx#mysx-20). This cuts onboard Vraw source if daughterboard provides Vraw. This is only used when EasyPCB is connected to a daughterboard.

- IRQ (Radio): Pin 2 on the Arduino is disabled so you can use this for interrupts instead of the radio. Most of the time this pin isn't used by the radio, so therefore disabled. If you want to enable this pin you can connect this jumper.

## MysX 2.4
This is [The MySensors expansion connector](https://www.mysensors.org/hardware/mysx) to which you can connect any daughterboard using this standard. This is also your main input/outputs for sensors and actuators so any wires can be connected accordingly. With this PCB as motherboard, you can use draughtboards if you need multiple copies and needs a quicker way to build - just like a shield on Arduino or Raspberry Pi.

If you want to create your own MysX daughterboard you can use [this template](https://github.com/sundberg84/HomeAutomation/tree/master/MysX%20template%20EasyPCB) (KiCad)

#### Example
- [Door sensor/Reed switch](https://forum.mysensors.org/topic/7836/what-did-you-build-today-pictures/321)
- [MysX-Dimmable-Led-board](https://www.openhardware.io/view/552/MysX-Dimmable-Led-board)

## Boxes / Enclosures

- Here are [images ](https://forum.mysensors.org/topic/6485/hdc1080-battery-operated-temp-humidity-sensor-with-wall-box/6)of a great box by @dbemowsk which fits EasyPCB + 2xAA and it can be found on [thingiverse](http://www.thingiverse.com/thing:2186286)

- Also a great box by barbuino [here](https://forum.mysensors.org/topic/6563/enclosure-bumper-for-easy-newbie-pcb).

## Revision changes

Rev 10 (Nrf24l01+ edition)
2018-06-04

Changes:
- Completely redesigned in KiCad.
- MysX location changed to accept more MysX boards and align like RFM version.
- Optional signing added
- Optional SPI flash added.
- Extra pins aligned to 2.45 vertical & horizontal
- Relocated Extra + Bat Measurer some to allow more space to booster
- Changed pull-up resistor from D3 to D5 to have one more pin for Interrupt
- Relocated D5 pullup, MysX and IRQ jumper some.
- Changed footprint (silk-screen) on the capacitor to easier show Gnd/Pos side.

Rev 10-1 (Nrf24l01+ edition)
2019-05-28
- Corrected a bug with flash not connected correctly
- Corrected a bug with flash capacitor not connected correctly



## I want it!

- Order 10pcs: [openhardware.io](https://www.openhardware.io/order/4/PCB10X) (Recommended!) and support me and MySensors! 
_(It may say another rev. at the order page but this is not EasyPCB rev but the rev for the manufacturer. I always update the Gerber files for sale! Current = Rev 10)_

- Download from this page to get Eagles and Gerber files. Note that the Gerber files are run with Itead cam job.

- If you want a faster shipping time or fewer pieces you can [buy them from me via Ebay](https://www.ebay.com/itm/223479433351). 

## Notes

All free to use as open hardware but I like if you tell me any cool project you make with it :)

All feedback welcome! The main goal is to keep it as simple as possible though.

## Inspiration
https://1drv.ms/f/s!Ak7D1EWM7GXggvQ9mzJzWJSMir8sLA

_(Note some photos are older revisions of the PCB)_

## Projects

- [Motion & Temp/Humidity sensor](https://forum.mysensors.org/topic/2740/easy-newbie-pcb-for-mysensors/37)
- [12v house solar power supply monitor](https://forum.mysensors.org/topic/2740/easy-newbie-pcb-for-mysensors/131)
- [UV/Light Sensor](https://forum.mysensors.org/topic/1456/rebuild-of-my-broken-433mhz-cresta-hideki-uv-sensor/11)
- [Robotic Lawn Mower supervisor](https://forum.mysensors.org/topic/3629/robotic-lawn-mower-supervisor)
- [HDC1080 battery operated temp/humidity sensor with wall box](https://forum.mysensors.org/topic/6485/hdc1080-battery-operated-temp-humidity-sensor-with-wall-box)
- [MySensors Weather Station ](https://forum.mysensors.org/topic/6681/mysensors-weather-station/113)
- [Plant monitor](https://forum.mysensors.org/topic/2147/office-plant-monitoring/161)
- [SI7021 temp/humidity sensor](https://forum.mysensors.org/topic/6434/solved-problems-with-an-si7021-temp-humidity-sensor/3)
- [Rain gauge/tipping bucket](https://forum.mysensors.org/topic/1950/domotiocz-rain-gauge/3)
- [RGB led strip](https://forum.mysensors.org/topic/6765/rgb-led-strip)
- [(Swedish) Repeater / Motion detector](https://www.byggahus.se/forum/threads/att-hemmasnickra-ett-hemautomationsystem-domoticz-mysensors-org.262039/#post-2321368)
- [(Swedish) Electricitymeter](https://www.byggahus.se/forum/threads/att-hemmasnickra-ett-hemautomationsystem-domoticz-mysensors-org.262039/page-11)
- [BME280 (Temp,Hum,Baro) + Light Sensor](https://forum.mysensors.org/topic/3816/bme280-temp-humidity-pressure-sensor/30)
- [Water leakage sensor](https://forum.mysensors.org/topic/7736/water-leakage-sensor-using-thin-ribbon-cable-testing-reliability)
- [Car Aux Battery Monitor](https://forum.mysensors.org/topic/7723/car-aux-battery-monitor/15)
- [Swimming Pool Thermometer](https://forum.mysensors.org/topic/8012/swimming-pool-thermometer)
- [Central Heating Controller](https://forum.mysensors.org/topic/7836/what-did-you-build-today-pictures/89)
- [Cat door/hatch on 2xAA](https://forum.mysensors.org/topic/7836/what-did-you-build-today-pictures/632)

## QnA / FAQ

**Q:** What is the battery life on 3.3V and booster?
**A:** Depending on what sensor you wish to run and how frequent you want to get data!
One example: DHT22, sleeping 15min and sending Temp/Hum with a china/ebay booster is about a year. You need to [desolder ](https://www.mysensors.org/build/battery)the led and voltage regulator on the Pro Mini 3.3v and use [sleep() mode](https://www.mysensors.org/download/sensor_api_20#sleeping) to save power.

**Q:** Why is the radio sticking outside the PCB?
**A:** Having metal close to the radio antenna will likely mess up the reception.

**Q:** Both Arduino and NRF are capable of operating down to about 2V. Why do we need the booster in battery operation. 
**A:** To be able to use the pro mini down to 2v you need to mess with the fuses which inst needed now (more newbie friendly). Also some sensors might require 3.3v

**Q:** What is the IRQ jumper for?
**A:** IRQ (or D2 on the pro mini) can handle interrupts and isnt used in all transceiver operations (not always needed). So this way you can choose to use IRQ either as interrupt or for the radio.

**Q:** Will it work with all Arduino Pro Mini?
**A:** No - only with the same footprint (most common) used on the PCB! [Look here](https://forum.mysensors.org/topic/2376/easy-newbie-pcb-for-mysensors/47).

**Q:** What is the purpose of the Raw connection under the radio connection?
**A:** Its a criteria of the MysX connector - to be able to switch RAW on/off from a daughter pcb. You dont have to think about it until you have a mother/daughter board.

**Q:** How could I connect radio's power input to boosted powering source to get stable 3.3v?
**A:** use regulated power instructions instead. Set the jumper on "reg" and bypass the voltage converter with a wire.
Whats good to know is that this has been tested over and over in this forum and the conclusion has been so far that if you run with 2xAA the best solution is to bypass the radio in the booster (i.e. use battery instructions - hence the difference). The radio can handle down to 1.9v so it wont die for a long time if you have some power savings in use. The booster might also cause noise and reduce its efficiency/range.

**Q:** Is it possible to use 5v mini + 9v battery with measurement ?
**A:** Powering it through RAW is possible but if you want to use the booster and battery measuring this is not an option , you need to power it through PWR and BAT jumper. I think what described here is possible but untested. First you need to find/create a booster that can handle the battery. Also you need to make corrections on the voltage divider(47k and 67k?) for the battery measuring and also code changes. Please share any test with this.

**Q:** When i use a 3,3V mini then i do not need the 3,3V regulator and it is powered with a battery. If i use a 5V mini then i need the regulator. Is this correct?
**A:** Correct statement. The radio cant handle 5v.

**Q:** Do i need the booster if batteries are used?
**A:** No, you can bypass it with a jumper/wire - but it will give you alot of extra. Without the booster the arduino 3.3v will die somewhere between 2.8 and 3 volts, with booster you can go down to 1.9v.

**Q:** How about the RAW option? How does it go to 5V? i need the regulator to go to 3,3V so how do i loose the 6-12V
**A:** There is a voltage regulater on board the pro mini that handels from 6-12v (be cautious using 12 v, 9v is max i recommend on clones). This will convert your RAW to 5v and provide the board with this. Then the external regulator will go from 5 to radio 3.3v. You could use a 12 to 3.3v regulator outside the PCB and use the 3.3v REG option.

**Q:** How do I access A2, A3 and D8?
**A:** They are not accesses through the PCB, so you need to directly solder to the pro mini.

**Q:** What's the 0.1 uF capacitor next to the battery terminals/voltage regulator for??
**A:** Its to maintain stability of the voltage regulator. If you look at different datasheet most voltage regulators has a typical application schematics where different capacitors is added before and after to make this. So the 10 and 0,1uF work together. Why 0,1 and 10? Well - I have seen this setup on the forum many times so I just went with that. There is alof to read about this, but I think the smaller cap can react faster while the bigger cap have more juice to give so to say. The capacitors are NOT needed if you doesnt use a voltage regulator.

**Q:** Why is the headers (MysX) for the sensors different between Rev 8 and Rev 9
**A:** One of the reasons I upgraded to Rev 9 is because MysX came out with a new version. MysX 2.X (which is used in Rev 9) has access to alot of better pins so I descided to upgrade to this. On previous EasyPCB rev (<9.0) I use MysX 1.X

**Q:** Can I use any other batteries than 2xAA (3v) ?
**A:** Yes - but the voltage needs to be regulated to fit the hardware on the board. You also needs to update the voltage divider to fit your battery voltage if you want to measure battery status (and using booster). [Here](https://forum.mysensors.org/topic/7797/supercap-solar-powered-mysensors-nodes-as-cheap-as-possible) is a example of 5.5v project with a voltage divider reading voltage status. 

## Ebay Link
